package org.msh.tb.bd.dashboard.summaryrep;

/**
 * Created by mauri on 20/05/2017.
 * Retrieves cached information to the UI.
 */

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.bd.dashboard.summaryrep.data.GeoDistributionData;
import org.msh.tb.bd.dashboard.summaryrep.data.SummaryIndicatorData;
import org.msh.tb.bd.dashboard.summaryrep.data.SummaryIndicatorsData;
import org.msh.tb.login.UserSession;
import org.msh.utils.DbCacheService;
import org.msh.utils.JsonUtils;

import java.util.List;

@Name("summaryIndicatorsHome")
public class SummaryIndicatorsHome {

    @In(create=true)
    DbCacheService dbCacheService;

    @In(create=true)
    SummaryIndicatorsGenerator summaryIndicatorsGenerator;

    private SummaryIndicatorsData data;

    /**
     * Searches for the cached indicator information. It it is not found, generates it.
     */
    public void load() {
        try {
            // get hash corresponding to the userworkspace logged in
            String hash = DashboardIndicatorUtils.getHash(UserSession.getUserWorkspace());

            // retrieve cached indicators
            data = dbCacheService.getCache(hash, SummaryIndicatorsData.class);

            // if indicator is not cached
            if (data == null || data.getIndicators() == null || data.getIndicators().size() == 0) {
                // generate indicator
                summaryIndicatorsGenerator.generateIndicators(UserSession.getUserWorkspace());

                // load again
                data = dbCacheService.getCache(hash, SummaryIndicatorsData.class);
            }

        }catch (Exception e) {
            e.printStackTrace();
            // avoid error after login
            data = null;
        }
    }

    public GeoDistributionData getGeoData() {
        if (data == null) {
            load();
        }

        return data.getGeoDistributionData();
    }

    public String getGeoDataJson() {
        return JsonUtils.objectToJSONString(getGeoData(),false);
    }

    public List<SummaryIndicatorData> getIndicators() {
        if (data == null) {
            load();
        }

        return data.getIndicators();
    }
}
